%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      MTFAnalyis.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file performs the analysis of the data collected during
%                 the MTF tests.
%-------------------------------------------------------------------------------


%%
% Use the linear transformation derived from sensor space (above) to
% display the RGB image in the processor window.
vci = imageSet(vci,'colorConversionMethod','MCC Optimized');
vci = imageSet(vci,'colorBalanceMethod','Gray World');% 
%vci = imageSet(vci,'internalCS','XYZ');

% First, compute with the default properties.  This uses bilinear
% demosaicing, no color conversion or balancing.  The sensor RGB values are
% simply set to the display RGB values.
vci = vcimageCompute(vci,sensor);
vcAddAndSelectObject(vci);
if (showISET == TRUE),
   vcimageWindow
end


% Run this code to get masterRect size
%%
%{
handles = ieSessionGet('vcimagehandles');
figure(handles.figure1);
ieInWindowMessage('Choose rectangular ROI (short sides must intersect edge)',handles);
[roiLocs,masterRect] = vcROISelect(vci);
masterRect
%}

%%
masterRect = [97    26   146   217];
roiLocs = vcRect2Locs(masterRect);

barImage = vcGetROIData(vci,roiLocs,'results');

c = masterRect(3)+1;
r = masterRect(4)+1;
barImage = reshape(barImage,r,c,3);

%figure; imagesc(rgb2gray(barImage)); axis image; colormap(gray);
%title('Bar Image');

pixel = sensorGet(sensor,'pixel');
dx = pixelGet(pixel,'width','mm');  

% Run the ISO 12233 code.  The results are stored in the window.
[results, fitme, esf] = ieISO12233(barImage,dx);

% Display the results
disp(['Nyquist Frequency: ', num2str(results.nyquistf)]);
disp(['MTF-50: ', num2str(results.mtf50)]);
disp(['Aliasing Percentage: ', num2str(results.aliasingPercentage)]);

% End of File
